* Definicia indexovych mnozin
Set i /1*46/
    m /1*2/
    t /A,B/
    s /GJM,ALT/;

    alias(i,j);
    alias(m,m1);

* Definicia parameterov
Parameter A1(i,j),B1(i,j),x1(j),u1(i),v1(j),
          A0(i,j),B0(i,j),x0(j),u0(i),v0(j);

$libinclude xlimport B0 C:\MaxEnt\Data\IO-96-98.xls IO96inputAGG00!a1:au47
$libinclude xlimport x0 C:\MaxEnt\Data\IO-96-98.xls IO96inputAGG00!a49:au50
$libinclude xlimport B1 C:\MaxEnt\Data\IO-96-98.xls IO98inputAGG00!a1:au47
$libinclude xlimport x1 C:\MaxEnt\Data\IO-96-98.xls IO98inputAGG00!a49:au50

    B0(i,j)=B0(i,j)/1000;
    B1(i,j)=B1(i,j)/1000;
    x0(j)=x0(j)/1000;
    x1(j)=x1(j)/1000;

    u0(i)=sum(j, B0(i,j));
    v0(j)=sum(i, B0(i,j));
    u1(i)=sum(j, B1(i,j));
    v1(j)=sum(i, B1(i,j));

Scalar F,G0,G1,N1,N5;
    N1=sum((i,j), 1);
    N5=sum(m, 1);

Parameter N4(i,j);

    A0(i,j)=B0(i,j)/x0(j);
    A1(i,j)=B1(i,j)/x1(j);

    G0=sum(j, u0(j));
    G1=sum(j, u1(j));

    F=G1;
*    F=1;

    G1=G1/F;
    v1(j)=v1(j)/F;
    u1(i)=u1(i)/F;

Parameter Z_GJM(i,j,m),Z_ALT(i,j,m);

* Definicia premennych a rovnic
Variables
    lambda(i)
    mi(j)
    gamma(i,j)
    H       entropy;

Equations
    obj_gjm    define objective function - golan & judge & miller
    obj_alt    define objective function - alternative;

    obj_gjm..    H =e= sum(i, lambda(i)*u1(i))
                     + sum(j, mi(j))
                     + sum((i,j), log(sum(m, exp(-(lambda(i)*v1(j)+mi(j))*Z_GJM(i,j,m)))));

    obj_alt..    H =e= sum(i, lambda(i)*u1(i))
                     + sum(j, mi(j)*v1(j))
                     + sum((i,j)$(N4(i,j) = N5), gamma(i,j))
                     + log(sum((i,j,m)$(Z_ALT(i,j,m) ne 0), exp(-lambda(i)*G1-mi(j)*G1-(gamma(i,j)/Z_ALT(i,j,m))$(N4(i,j) = N5))));

Model IO_GJM /obj_gjm/ ;
Model IO_ALT /obj_alt/ ;

option NLP=CONOPT;

Parameter omega1(i,j),omega2,p(i,j,m),
          A1_HAT(i,j,s,t),B1_HAT(i,j,s,t),
          E_A(i,j,s,t),
          E_B(i,j,s,t),
          P_B(i,j,s,t);

    Z_GJM(i,j,'1') = 0;
    Z_GJM(i,j,'2') = 1;

    Z_ALT(i,j,m) = Z_GJM(i,j,m);

    N4(i,j)=sum(m$(Z_ALT(i,j,m) ne 0), 1);

    lambda.l(i)=0;
    mi.l(j)=0;
    gamma.l(i,j)=0;

* Optimalizacia
    solve IO_GJM using NLP minimizing H;

       omega1(i,j)=sum(m, exp(-(lambda.l(i)*v1(j)+mi.l(j))*Z_GJM(i,j,m)));
       p(i,j,m)=exp(-(lambda.l(i)*v1(j)+mi.l(j))*Z_GJM(i,j,m))/omega1(i,j);
       A1_HAT(i,j,'GJM','A')=F*v1(j)/x1(j)*sum(m, Z_GJM(i,j,m)*p(i,j,m));
       B1_HAT(i,j,'GJM','A')=A1_HAT(i,j,'GJM','A')*x1(j);

    lambda.l(i)=0;
    mi.l(j)=0;
    gamma.l(i,j)=0;

    solve IO_ALT using NLP minimizing H;

       omega2=sum((i,j,m)$(Z_ALT(i,j,m) ne 0), exp(-lambda.l(i)*G1-mi.l(j)*G1-(gamma.l(i,j)/Z_ALT(i,j,m))$(N4(i,j) = N5)));
       p(i,j,m)$(Z_ALT(i,j,m) ne 0)=exp(-log(Z_ALT(i,j,m))-lambda.l(i)*G1-mi.l(j)*G1-(gamma.l(i,j)/Z_ALT(i,j,m))$(N4(i,j) = N5))/omega2;
       p(i,j,m)$(Z_ALT(i,j,m) = 0)=1-sum(m1, p(i,j,m1)$(Z_ALT(i,j,m1) ne 0));
       A1_HAT(i,j,'ALT','A')=F*G1/x1(j)*sum(m, Z_ALT(i,j,m)*p(i,j,m));
       B1_HAT(i,j,'ALT','A')=A1_HAT(i,j,'ALT','A')*x1(j);

    Z_GJM(i,j,'1') = 0; Z_GJM(i,j,'2') = 1;
    Z_GJM(i,j,'1')$(v1(j) ne 0)=max(0,(v1(j)-(G1-u1(i)))/v1(j));
    Z_GJM(i,j,'2')$(v1(j) ne 0)=min(1,u1(i)/v1(j));

    Z_ALT(i,j,'1')=max(0,(v1(j)-(G1-u1(i)))/G1);
    Z_ALT(i,j,'2')=(min(u1(i)/G1,v1(j)/G1));

    N4(i,j)=sum(m$(Z_ALT(i,j,m) ne 0), 1);

    lambda.l(i)=0;
    mi.l(j)=0;
    gamma.l(i,j)=0;

    solve IO_GJM using NLP minimizing H;

       omega1(i,j)=sum(m, exp(-(lambda.l(i)*v1(j)+mi.l(j))*Z_GJM(i,j,m)));
       p(i,j,m)=exp(-(lambda.l(i)*v1(j)+mi.l(j))*Z_GJM(i,j,m))/omega1(i,j);
       A1_HAT(i,j,'GJM','B')=F*v1(j)/x1(j)*sum(m, Z_GJM(i,j,m)*p(i,j,m));
       B1_HAT(i,j,'GJM','B')=A1_HAT(i,j,'GJM','B')*x1(j);

    lambda.l(i)=0;
    mi.l(j)=0;
    gamma.l(i,j)=0;

    solve IO_ALT using NLP minimizing H;

       omega2=sum((i,j,m)$(Z_ALT(i,j,m) ne 0), exp(-lambda.l(i)*G1-mi.l(j)*G1-(gamma.l(i,j)/Z_ALT(i,j,m))$(N4(i,j) = N5)));
       p(i,j,m)$(Z_ALT(i,j,m) ne 0)=exp(-log(Z_ALT(i,j,m))-lambda.l(i)*G1-mi.l(j)*G1-(gamma.l(i,j)/Z_ALT(i,j,m))$(N4(i,j) = N5))/omega2;
       p(i,j,m)$(Z_ALT(i,j,m) = 0)=1-sum(m1, p(i,j,m1)$(Z_ALT(i,j,m1) ne 0));
       A1_HAT(i,j,'ALT','B')=F*G1/x1(j)*sum(m, Z_ALT(i,j,m)*p(i,j,m));
       B1_HAT(i,j,'ALT','B')=A1_HAT(i,j,'ALT','B')*x1(j);

       E_A(i,j,s,t) = A1_HAT(i,j,s,t)-A1(i,j);
       E_B(i,j,s,t) = B1_HAT(i,j,s,t)-B1(i,j);
       P_B(i,j,s,t)$B1(i,j) = abs(E_B(i,j,s,t))/B1(i,j);

* Vypocet parametrov
Parameter MAD_A(s,t),SEM_A(s,t),
          MAD_B(s,t),SEM_B(s,t),
          MaxPE(s,t),MAPE(s,t),
          GOF_A(s,t),GOF_B(s,t),
          CORR_A(s,t),CORR_B(s,t),
          mean_A1_HAT(s,t),mean_A1,
          mean_B1_HAT(s,t),mean_B1,
          mean0,mean1,
          stddev0,stddev1;

       MAD_A(s,t) = sum((i,j), abs(E_A(i,j,s,t)))/N1;
       SEM_A(s,t) = sum((i,j), power(E_A(i,j,s,t),2))/N1;

       MAD_B(s,t) = sum((i,j), abs(E_B(i,j,s,t)))/N1;
       SEM_B(s,t) = sum((i,j), power(E_B(i,j,s,t),2))/N1;

       MaxPE(s,t) = smax((i,j), P_B(i,j,s,t));
       MAPE(s,t) = sum((i,j), P_B(i,j,s,t))/N1;

       GOF_A(s,t) = sum((i,j)$A1_HAT(i,j,s,t), power(E_A(i,j,s,t),2)/(N1*A1_HAT(i,j,s,t)));
       mean_A1_HAT(s,t)=sum((i,j), A1_HAT(i,j,s,t))/N1;
       mean_A1=sum((i,j), A1(i,j))/N1;
       CORR_A(s,t) = (sum((i,j),(A1_HAT(i,j,s,t)-mean_A1_HAT(s,t))*(A1(i,j)-mean_A1))/N1)/
         ((sum((i,j),power(A1_HAT(i,j,s,t)-mean_A1_HAT(s,t),2))/N1)*(sum((i,j),power(A1(i,j)-mean_A1,2))/N1))**0.5;

       GOF_B(s,t) = sum((i,j)$B1_HAT(i,j,s,t), power(E_B(i,j,s,t),2)/(N1*B1_HAT(i,j,s,t)));
       mean_B1_HAT(s,t)=sum((i,j), B1_HAT(i,j,s,t))/N1;
       mean_B1=sum((i,j), B1(i,j))/N1;
       CORR_B(s,t) = (sum((i,j),(B1_HAT(i,j,s,t)-mean_B1_HAT(s,t))*(B1(i,j)-mean_B1))/N1)/
         ((sum((i,j),power(B1_HAT(i,j,s,t)-mean_B1_HAT(s,t),2))/N1)*(sum((i,j),power(B1(i,j)-mean_B1,2))/N1))**0.5;

       mean0=sum((i,j), B0(i,j))/N1;
       mean1=sum((i,j), B1(i,j))/N1;
       stddev0=sum((i,j), power((B0(i,j)-mean0),2))/N1;
       stddev1=sum((i,j), power((B1(i,j)-mean1),2))/N1;

option decimals = 5

Display MAD_A,SEM_A,
        MAD_B,SEM_B,
        MaxPE,MAPE,
        GOF_A,GOF_B,
        CORR_A,CORR_B,
        mean0,mean1,
        stddev0,stddev1;